// Copyright 2020 Espressif Systems (Shanghai) PTE LTD
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma once

#include <stdbool.h>
#include <stdint.h>

#include "esp_netif.h"
#include "driver/uart.h"

// Forward declare modem object
typedef struct esp_uarteth_modem esp_uarteth_modem_t;

/** @brief Configuration structure for UART-ETH modem interface
 *
 */
typedef struct {
    uart_port_t uart_dev;   /* UART device for reading and writing UART-ETH information, this must be initialised externally */

    int uart_tx_pin;        /* UART TX pin number */
    int uart_rx_pin;        /* UART TX pin number */

    uint32_t uart_baud;     /* UART baud rate */
    uint32_t rx_buffer_len; /* Length of buffer for RX messages */
} esp_uarteth_modem_config_t;


/** @brief Create a uarteth modem
 *
 * @param[in]    uarteth configured esp netif
 * @param[in]    configuration for the uarteth modem
 *
 * @returns
 *          - uarteth modem driver glue object
 */
void *esp_uarteth_modem_create(esp_netif_t *uarteth_netif, esp_uarteth_modem_config_t *modem_config);

/** @brief Destroy a uarteth modem
 *
 * @param[in]    uarteth modem object for destruction
 *
 * @return
 *          - ESP_OK on success
 */
esp_err_t esp_uarteth_modem_destroy(esp_uarteth_modem_t *uarteth_modem);
