#include "ppp_proto.h"
#include <stdlib.h>
#include <string.h>

#define PPP_VALID_MAGIC 0xdeadbeef
#define min(a, b) (((a) < (b)) ? (a) : (b))

typedef struct {
    uint32_t valid_magic;
    uint16_t state;
    uint16_t current_index;
    uint32_t buffer_len;
    uint8_t data[0];    
} ppp_proto_ctx_t;

int ppp_proto_new(uint16_t max_frame_len, uint32_t *ppp_proto_handle)
{
    if(max_frame_len == 0 || ppp_proto_handle == NULL) {
        return PROTO_RET_INVALID_PARAM;
    }

    ppp_proto_ctx_t *ctx = malloc(sizeof(ppp_proto_ctx_t) + max_frame_len);
    if (ctx == NULL) {
        return PROTO_RET_MEM_NOT_ENOUGH;
    }
    memset(ctx, 0, sizeof(ppp_proto_ctx_t) + max_frame_len);
    ctx->valid_magic = PPP_VALID_MAGIC;
    ctx->buffer_len = max_frame_len;

    *ppp_proto_handle = (uint32_t)ctx;
    return PROTO_RET_SUCCESS;
}

int ppp_proto_free(uint32_t proto_handle)
{
    ppp_proto_ctx_t *handle = (ppp_proto_ctx_t *)proto_handle;
    if (handle == NULL || handle->valid_magic != PPP_VALID_MAGIC) {
        return PROTO_RET_INVALID_PARAM;
    }
    free(handle);
    return PROTO_RET_SUCCESS;
}

int ppp_proto_feed(uint32_t proto_handle, uint8_t *data, uint16_t len)
{
    ppp_proto_ctx_t *handle = (ppp_proto_ctx_t *)proto_handle;
    if (handle == NULL || handle->valid_magic != PPP_VALID_MAGIC) {
        return PROTO_RET_INVALID_PARAM;
    }
    if (data == NULL || len == 0 || len > handle->buffer_len) {
        return PROTO_RET_INVALID_PARAM;
    }

    uint16_t left = handle->buffer_len - handle->current_index -1;
    if (left < len) { /* 清空缓冲区 */
        
    }

}

uint8_t *ppp_proto_take_frame(uint32_t proto_handle)
{
    ppp_proto_ctx_t *handle = (ppp_proto_ctx_t *)proto_handle;
    if (handle == NULL || handle->valid_magic != PPP_VALID_MAGIC) {
        return PROTO_RET_INVALID_PARAM;
    }


}
